clear all

ssc install reghdfe

cd "REMOVED" 

import delimited "lvr_data_for_analysis.csv"

/* Convert variables from string to integer */
encode type, generate(loan_type)
encode period, generate(qtr)
encode bank, generate(bank_fac)

// Remove NAs and replace with missing value, first force variables to string to 
//   make it easier.
foreach v of varlist gdp_qpd-qtr {
	tostring `v', force replace
	replace `v' = "." if `v' == "NA" | `v' == "-Inf" | `v' == "Inf"
}
destring, replace

// truncate approvals outliers
replace appr_gr = . if appr_gr > 3 & appr_gr != . & appr_gr_l1 == .
replace appr_gr_l1 = . if appr_gr_l1 > 3 & appr_gr_l1 != . & appr_gr_l2 == .
replace appr_gr_l2 = . if appr_gr_l2 > 3 & appr_gr_l2 != . & appr_gr_l3 == .
foreach x of varlist appr_gr appr_gr_l1 appr_gr_l2 {
	replace `x' = 3 if `x' > 3 & `x' != .
}

// Generate dummies for loan types
gen inv_type = type == "inv_lvrto80" | type == "inv_lvr80to90" | type == "inv_lvr90up"
gen occ_type = type == "occ_lvrto80" | type == "occ_lvr80to90" | type == "occ_lvr90up"
gen lvrto80 = type == "inv_lvrto80" | type == "occ_lvrto80"
gen lvr80to90 = type == "inv_lvr80to90" | type == "occ_lvr80to90"
gen lvr90up = type == "inv_lvr90up" | type == "occ_lvr90up"

// Generate policy dummies
gen p1dum = period == "2015-09-30" | period == "2015-12-31"
gen p2dum = period == "2017-06-30" | period == "2017-09-30"

// Generate policy and lona-type interactions.
gen p1_lowlvr = p1dum * lvrto80
gen p1_midlvr = p1dum * lvr80to90
gen p1_hghlvr = p1dum * lvr90up
gen p2_lowlvr = p2dum * lvrto80
gen p2_midlvr = p2dum * lvr80to90
gen p2_hghlvr = p2dum * lvr90up

// Generate bank type dummies
gen MajorBank = bank == "ANZ" | bank == "CBA" | bank == "NAB" | bank == "WBC"

// regressions - first policy
estimates clear
quietly reghdfe appr_gr p1_lowlvr p1_midlvr p1_hghlvr appr_gr_l1 appr_gr_l2 gdp_qpd housepr_qpd lcapitalratio lfunding ///
if inv_type == 1 & MajorBank == 1, absorb(bank_fac#loan_type) 
eststo
quietly reghdfe appr_gr p1_lowlvr p1_midlvr p1_hghlvr appr_gr_l1 appr_gr_l2 gdp_qpd housepr_qpd lcapitalratio lfunding ///
if occ_type == 1 & MajorBank == 1, absorb(bank_fac#loan_type) 
eststo
quietly reghdfe appr_gr p1_lowlvr p1_midlvr p1_hghlvr appr_gr_l1 appr_gr_l2 gdp_qpd housepr_qpd lcapitalratio lfunding ///
if inv_type == 1 & MajorBank == 0, absorb(bank_fac#loan_type) 
eststo
quietly reghdfe appr_gr p1_lowlvr p1_midlvr p1_hghlvr appr_gr_l1 appr_gr_l2 gdp_qpd housepr_qpd lcapitalratio lfunding ///
if occ_type == 1 & MajorBank == 0, absorb(bank_fac#loan_type) 
eststo
esttab, label keep(p1_*) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)

// regressions - second policy
estimates clear
quietly reghdfe appr_gr p2_lowlvr p2_midlvr p2_hghlvr appr_gr_l1 appr_gr_l2 gdp_qpd housepr_qpd lcapitalratio lfunding ///
if inv_type == 1 & MajorBank == 1, absorb(bank_fac#loan_type) 
eststo
quietly reghdfe appr_gr p2_lowlvr p2_midlvr p2_hghlvr appr_gr_l1 appr_gr_l2 gdp_qpd housepr_qpd lcapitalratio lfunding ///
if occ_type == 1 & MajorBank == 1, absorb(bank_fac#loan_type) 
eststo
quietly reghdfe appr_gr p2_lowlvr p2_midlvr p2_hghlvr appr_gr_l1 appr_gr_l2 gdp_qpd housepr_qpd lcapitalratio lfunding ///
if inv_type == 1 & MajorBank == 0, absorb(bank_fac#loan_type) 
eststo
quietly reghdfe appr_gr p2_lowlvr p2_midlvr p2_hghlvr appr_gr_l1 appr_gr_l2 gdp_qpd housepr_qpd lcapitalratio lfunding ///
if occ_type == 1 & MajorBank == 0, absorb(bank_fac#loan_type)
eststo
esttab, label keep(p2_*) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)

